using System;
using System.Collections.Generic;
using System.Linq;

public class Tacka
{
    public long X { get; set; }
    public long Y { get; set; }
}

public class Resenje
{
    private static long PrebrojInverzije(List<long> lista)
    {
        if (lista.Count <= 1)
        {
            return 0;
        }

        long count = 0;
        int middle = lista.Count / 2;
        List<long> left = lista.GetRange(0, middle);
        List<long> right = lista.GetRange(middle, lista.Count - middle);

        count += PrebrojInverzije(left);
        count += PrebrojInverzije(right);
        int i = 0, j = 0, k = 0;
        while (i < left.Count && j < right.Count)
        {
            if (left[i] <= right[j])
            {
                lista[k++] = left[i++];
            }
            else
            {
                count += (left.Count - i);
                lista[k++] = right[j++];
            }
        }

        while (i < left.Count)
        {
            lista[k++] = left[i++];
        }

        while (j < right.Count)
        {
            lista[k++] = right[j++];
        }

        return count;
    }

    private static long PrebrojNeinverzije(List<long> lista)
    {
        int m = lista.Count;
        if (m < 2) return 0;
        return (long)m * (m - 1) / 2;
    }
    private static long PrebrojOrtogonalneSusrete(List<long> lista)
    {
        if (lista.Count <= 1)
        {
            return 0;
        }

        long countPar = 0;
        long countNepar = 0;

        foreach (var val in lista)
        {
            if (val % 2 == 0)
            {
                countPar++;
            }
            else
            {
                countNepar++;
            }
        }
        long susretiPar = countPar * (countPar - 1) / 2;
        long susretiNepar = countNepar * (countNepar - 1) / 2;

        return susretiPar + susretiNepar;
    }

    public static void Main(string[] args)
    {
        if (!int.TryParse(Console.ReadLine(), out int N) || N < 2)
        {
            return;
        }

        Tacka[] tacke = new Tacka[N];

        for (int i = 0; i < N; i++)
        {
            string line = Console.ReadLine();
            if (string.IsNullOrEmpty(line)) continue;
            string[] parts = line.Split(' ');
            
            if (parts.Length == 2 && 
                long.TryParse(parts[0], out long x) && 
                long.TryParse(parts[1], out long y))
            {
                tacke[i] = new Tacka { X = x, Y = y };
            }
            else
            {
            }
        }

        long ukupanBrojPozdrava = 0;
        Dictionary<long, List<long>> grupePoU = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            long u = t.X + t.Y;
            long v = t.X - t.Y;
            if (!grupePoU.ContainsKey(u))
            {
                grupePoU[u] = new List<long>();
            }
            grupePoU[u].Add(v);
        }

        foreach (var group in grupePoU.Values)
        {
            ukupanBrojPozdrava += PrebrojInverzije(group);
        }
        Dictionary<long, List<long>> grupePoV = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            long u = t.X + t.Y;
            long v = t.X - t.Y;
            if (!grupePoV.ContainsKey(v))
            {
                grupePoV[v] = new List<long>();
            }
            grupePoV[v].Add(u);
        }

        foreach (var group in grupePoV.Values)
        {
            ukupanBrojPozdrava += PrebrojNeinverzije(group);
        }
        Dictionary<long, List<long>> grupePoY = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            if (!grupePoY.ContainsKey(t.Y))
            {
                grupePoY[t.Y] = new List<long>();
            }
            grupePoY[t.Y].Add(t.X);
        }

        foreach (var group in grupePoY.Values)
        {
            ukupanBrojPozdrava += PrebrojOrtogonalneSusrete(group);
        }
        Dictionary<long, List<long>> grupePoX = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            if (!grupePoX.ContainsKey(t.X))
            {
                grupePoX[t.X] = new List<long>();
            }
            grupePoX[t.X].Add(t.Y);
        }

        foreach (var group in grupePoX.Values)
        {
            ukupanBrojPozdrava += PrebrojOrtogonalneSusrete(group);
        }
        Console.WriteLine(ukupanBrojPozdrava);
    }
}